
IF EXISTS
(
    SELECT *
    FROM sys.views
    WHERE object_id = OBJECT_ID(N'dbo.V_TELE_PAINEL_ECOMMERCE')
)
    DROP VIEW dbo.V_TELE_PAINEL_ECOMMERCE;
GO

CREATE VIEW dbo.V_TELE_PAINEL_ECOMMERCE

AS

SELECT
    CONVERT( VARCHAR( 100 ) , 'LINX ECOMMERCE' ) AS ECOMMERCE
    , I.DATA_CADASTRO 
    , I.CODIGO_TELEVENDAS AS PEDIDO_GESTAO 
    , I.ORDER_ID AS PEDIDO_SITE
    , I.[STATUS] AS STATUS_PEDIDO
    , CASE WHEN ISNULL(T.CD_ORC,0)= 0 THEN 
		   'NO INTEGRADO' 
	   ELSE 
		   'INTEGRADO' 
       END AS STATUS_INTEGRACAO

    , CASE WHEN ISNULL(C.RZ_CLI,'')= '' THEN 
		   'NO INTEGRADO' 
	   ELSE 
		   C.RZ_CLI 
      END AS CLIENTE
    , I.MENSAGEM_FALHA 
    , I.CODIGO_FILIAL 
    , I.ID_MESSAGE
    , I.JSON_RECEBIDO_LINX_IO 
    , I.JSON_ENVIADO_TELE_VENDAS 
    , I.STATUS_TELEVENDAS
FROM 
    INTEGRADOR_LINX_ECOMMERCE_PEDIDO I
    LEFT JOIN TELE_ORC T ON 
        I.CODIGO_TELEVENDAS = T.CD_ORC
    LEFT JOIN RC_CLI C ON 
        T.CD_EMP = C.CD_EMP
        AND T.CD_CLI = C.CD_CLI

UNION ALL

SELECT 
    'VTEX' AS ECOMMERCE
    , I.DATA_CADASTRO 
    , I.CODIGO_TELEVENDAS AS PEDIDO_GESTAO 
    , I.CODIGO_ECOMMERCE AS PEDIDO_SITE
    , I.STATUS_PEDIDO
    , CASE WHEN ISNULL(T.CD_ORC,0)= 0 THEN 
		   'NO INTEGRADO' 
	   ELSE 
		   'INTEGRADO' 
      END AS STATUS_INTEGRACAO
    , CASE WHEN ISNULL(C.RZ_CLI,'')= '' THEN 
		   'NO INTEGRADO' 
	   ELSE 
		   C.RZ_CLI 
      END AS CLIENTE
    , '' AS MENSAGEM_FALHA 
    , I.CODIGO_FILIAL 
    , '' AS ID_MESSAGE
    , I.JSON_RECEBIDO AS JSON_RECEBIDO_LINX_IO 
    , I.JSON_ENVIADO AS JSON_ENVIADO_TELE_VENDAS 
    , TELE_ORC_ETAPA.OBS_ETAPA AS STATUS_TELEVENDAS
FROM 
    INTEGRADOR_VTEX_CONTROLE_PEDIDO I
    LEFT JOIN TELE_ORC T ON 
		I.CODIGO_TELEVENDAS = T.CD_ORC
	LEFT JOIN TELE_ORC_ETAPA ON
		T.CD_ORC = TELE_ORC_ETAPA.CD_ORC
		AND T.CD_ORC_ETAPA = TELE_ORC_ETAPA.CD_ORC_ETAPA
    LEFT JOIN RC_CLI C ON 
        T.CD_EMP = C.CD_EMP
        AND T.CD_CLI = C.CD_CLI

UNION ALL

SELECT 
    ECOMMERCE AS ECOMMERCE
    , I.DATA_PEDIDO AS DATA_CADASTRO 
    , I.CD_ORC  AS PEDIDO_GESTAO 
    , I.CODIGO_PEDIDO AS PEDIDO_SITE
    , CASE WHEN I.FINALIZADO = 1 THEN 
		   'FINALIZADO' 
	   ELSE 
		   'PENDENTE' 
      END AS STATUS_PEDIDO
    , CASE WHEN ISNULL(T.CD_ORC,0)= 0 THEN 
		   'NO INTEGRADO' 
	   ELSE 
		   'INTEGRADO' 
      END AS STATUS_INTEGRACAO
    , CASE WHEN ISNULL(C.RZ_CLI,'')= '' THEN 
		   'NO INTEGRADO' 
	   ELSE 
		   C.RZ_CLI 
      END AS CLIENTE
    , I.MENSAGEM_ERRO AS MENSAGEM_FALHA 
    , T.CD_FILIAL AS CODIGO_FILIAL 
    , I.CODIGO_STATUS AS ID_MESSAGE
    , I.JSON_PEDIDO AS JSON_RECEBIDO_LINX_IO 
    , '' AS JSON_ENVIADO_TELE_VENDAS 
    , TELE_ORC_ETAPA.OBS_ETAPA AS STATUS_TELEVENDAS
FROM 
    INTEGRA_ECOMMERCE_PEDIDO I
    LEFT JOIN TELE_ORC T ON 
        I.CD_ORC = T.CD_ORC
	LEFT JOIN TELE_ORC_ETAPA ON
		T.CD_ORC = TELE_ORC_ETAPA.CD_ORC
		AND T.CD_ORC_ETAPA = TELE_ORC_ETAPA.CD_ORC_ETAPA
    LEFT JOIN RC_CLI   C ON 
        T.CD_EMP = C.CD_EMP
        AND T.CD_CLI = C.CD_CLI


GO